<?php

namespace App\Models\Newletter;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SuppliedNewsletterGroup extends Model 
{

    protected $table = 'supplied_newsletter_groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function supplied_newsletters()
    {
        return $this->hasMany('App\Models\Newletter\SuppliedNewsletter');
    }

    public function clients()
    {
        return $this->belongsToMany('App\Models\Newletter\Client');
    }

}